/*------------------------------------------------------------------------------*
 * File Name: FitExpDecay.h													*
 * Creation: YuI 11/25/2002													    *
 * Purpose: Origin C header	for Operation class and other related functions		*
 * Copyright (c) OriginLab Corp.2002											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 4/13/05 FUNCTION_NAME_WITH_PREFIX											*
 * DG 6/1/05 QA70-7157 v8.0244 EXPDECAY_CHANGE_DEFAULT_FUNCTION					*
 *------------------------------------------------------------------------------*/
 
#include <origin.h>
#include "FitCommon.h"

#ifdef _FOR_SMART_LOADING_ONLY
#include "analysis_utils.h"
#include <stats_utils.h>
#include "stats_guis.h"
#include "stats_operations.h"
#endif
#include "NLFitSession.h"
#include "FitNL.h"


class OC_REGISTERED	FitExpDecay: public FitNL
{
protected:
	//virtual 
	string GetAnalysisName(int nOption)
	{
		string str = _L("Fit Exp Decay");
		if(nOption < 0)
			return str;
		
		string strTemp;
		strTemp.Format(_L("(Terms = %d)"), nOption + 1);
		
		return str + " " + strTemp;
	}
	// Virtual 
	string GetClassName() {return "FitExpDecay";}

	//virtual 
	bool GetCategoryFuncNames(TreeNode& trOperation, string& strCategory, string& strFunction, vector<string>& vsFilterList)
	{
		//if(NLFitBase::GetCategoryFuncNames(trOperation, strCategory, strFunction, vsFilterList))
		//	return true;
		strCategory = "Exponential";
		///DG 4/13/05 FUNCTION_NAME_WITH_PREFIX
		//vector<string> vsTemp = {"ExpDecay1", "Expdecay2", "Expdecay3", "ExpDec1", "ExpDec2", "ExpDec3"};
		vector<string> vsTemp = {"System: ExpDecay1", "System: Expdecay2", "System: Expdecay3", "System: ExpDec1", "System: ExpDec2", "System: ExpDec3"};
		///end FUNCTION_NAME_WITH_PREFIX
		
		//strFunction = vsTemp[0];	///DG EXPDECAY_CHANGE_DEFAULT_FUNCTION
		strFunction = vsTemp[3];
		
		vsFilterList = vsTemp;	
		return false;// indicate Category cannot be changed
	}
};




